//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System.Collections.Generic;
using Microsoft.VisualStudio.QualityTools.UnitTesting.Framework;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection.Tests
{
	[TestClass]
	public class CollectionPropertyParameterFixture
	{

		[TestMethod]
		public void CreateACollectionObjectWithValueCollectionInjection()
		{
			InjectionFactory<CollectionObject, CollectionObjectConfiguration> factory = new InjectionFactory<CollectionObject, CollectionObjectConfiguration>();

			CollectionObjectConfiguration config = CreateCollectionObject();

			CollectionObject obj = factory.Create(config, new NullConfigurationSource());

			Assert.IsNotNull(obj);
			Assert.AreEqual<int>(2, obj.SimpleObjects.Count);
			Assert.AreEqual<string>("fred", obj.SimpleObjects[0].Name);
		}
		
		[TestMethod]
		public void GetValueFromConfigurationObject()
		{
            CollectionFactory<ICollection<ISimpleObject>, ISimpleObject, SimpleObjectConfiguration, IList<SimpleObjectConfiguration>> strategy = new CollectionFactory<ICollection<ISimpleObject>, ISimpleObject, SimpleObjectConfiguration, IList<SimpleObjectConfiguration>>(typeof(List<ISimpleObject>), new NullFactory<ISimpleObject, SimpleObjectConfiguration>());

			Assert.IsNotNull(strategy.CollectionType);
			Assert.IsNotNull(strategy.ElementFactory);

			CollectionObjectConfiguration config = CreateCollectionObject();
			IList<ISimpleObject> obj = (IList<ISimpleObject>)strategy.Create(config.SimpleObjects, new NullConfigurationSource());

			Assert.IsNotNull(obj);
			Assert.AreEqual<int>(2, obj.Count);
			Assert.AreEqual<string>("fred", obj[0].Name);
		}

		private static CollectionObjectConfiguration CreateCollectionObject()
		{
			CollectionObjectConfiguration config = new CollectionObjectConfiguration();
			config.SimpleObjects.Add(new SimpleObjectConfiguration("fred"));
			config.SimpleObjects.Add(new SimpleObjectConfiguration("wilma"));
			return config;
		}

		class CollectionObject
		{
			private IList<ISimpleObject> simpleObjects;

			public CollectionObject(IList<ISimpleObject> simpleObjects)
			{
				this.simpleObjects = simpleObjects;
			}

			public IList<ISimpleObject> SimpleObjects
			{
				get { return simpleObjects; }
			}
		}

		[PropertyParameter(0, typeof(List<ISimpleObject>), "SimpleObjects")]
		class CollectionObjectConfiguration
		{
			private IList<SimpleObjectConfiguration> simpleObjects = new List<SimpleObjectConfiguration>();

            [CollectionConverter(typeof(List<ISimpleObject>))]
			public IList<SimpleObjectConfiguration> SimpleObjects
			{
				get { return simpleObjects; }
			}
		}
	}
}
